clc;
clear;
close all;

tic

disp("Loading precipitation data...")

name = {'prec'}; % print the name of the folder
folder = cellfun(@(p) addpath(strrep("wc2.1_30s_%PARAM%", "%PARAM%", p)), name, 'UniformOutput', false);

months = sprintfc('%02d', 12); % print the # of months

[prec01, ref] = readgeoraster(strrep("wc2.1_30s_prec\wc2.1_30s_prec_01.tif", "%m%", months));
prec01 = single(prec01);
prec01(prec01 == (min(prec01, [], "all"))) = NaN;
disp("01")

prec02 = readgeoraster(strrep("wc2.1_30s_prec\wc2.1_30s_prec_02.tif", "%m%", months));
prec02 = single(prec02);
prec02(prec01 == (min(prec02, [], "all"))) = NaN;
disp("02")

prec03 = readgeoraster(strrep("wc2.1_30s_prec\wc2.1_30s_prec_03.tif", "%m%", months));
prec03 = single(prec03);
prec03(prec03 == (min(prec03, [], "all"))) = NaN;
disp("03")

prec04 = readgeoraster(strrep("wc2.1_30s_prec\wc2.1_30s_prec_04.tif", "%m%", months));
prec04 = single(prec04);
prec04(prec04 == (min(prec04, [], "all"))) = NaN;
disp("04")

prec05 = readgeoraster(strrep("wc2.1_30s_prec\wc2.1_30s_prec_05.tif", "%m%", months));
prec05 = single(prec05);
prec05(prec05 == (min(prec05, [], "all"))) = NaN;
disp("05")

prec06 = readgeoraster(strrep("wc2.1_30s_prec\wc2.1_30s_prec_06.tif", "%m%", months));
prec06 = single(prec06);
prec06(prec06 == (min(prec06, [], "all"))) = NaN;
disp("06")

prec07 = readgeoraster(strrep("wc2.1_30s_prec\wc2.1_30s_prec_07.tif", "%m%", months));
prec07 = single(prec07);
prec07(prec07 == (min(prec07, [], "all"))) = NaN;
disp("07")

prec08 = readgeoraster(strrep("wc2.1_30s_prec\wc2.1_30s_prec_08.tif", "%m%", months));
prec08 = single(prec08);
prec08(prec08 == (min(prec08, [], "all"))) = NaN;
disp("08")

prec09 = readgeoraster(strrep("wc2.1_30s_prec\wc2.1_30s_prec_09.tif", "%m%", months));
prec09 = single(prec09);
prec09(prec09 == (min(prec09, [], "all"))) = NaN;
disp("09")

prec10 = readgeoraster(strrep("wc2.1_30s_prec\wc2.1_30s_prec_10.tif", "%m%", months));
prec10 = single(prec10);
prec10(prec10 == (min(prec10, [], "all"))) = NaN;
disp("10")

prec11 = readgeoraster(strrep("wc2.1_30s_prec\wc2.1_30s_prec_11.tif", "%m%", months));
prec11 = single(prec11);
prec11(prec11 == (min(prec11, [], "all"))) = NaN;
disp("11")

prec12 = readgeoraster(strrep("wc2.1_30s_prec\wc2.1_30s_prec_12.tif", "%m%", months));
prec12 = single(prec12);
prec12(prec12 == (min(prec12, [], "all"))) = NaN;
disp("12")

prec_tot = (prec01 + prec02 + prec03 + prec04 + prec05 + prec06 +...
    prec07 + prec08 + prec09 + prec10 + prec11 + prec12) ./ 12;
disp("prec_tot")

%%
clear prec01 prec02 prec03 prec04 prec05 prec06 prec07 prec08 prec09 prec10 prec11 prec12;


%%

disp("Loading PET data...")

PET01 = load("PET_01.mat");
PET01 = PET01.PET;
disp("01")

PET02 = load("PET_02.mat");
PET02 = PET02.PET;
disp("02")

PET03 = load("PET_03.mat");
PET03 = PET03.PET;
disp("03")

PET04 = load("PET_04.mat");
PET04 = PET04.PET;
disp("04")

PET05 = load("PET_05.mat");
PET05 = PET05.PET;
disp("05")

PET06 = load("PET_01.mat");
PET06 = PET06.PET;
disp("06")

PET07 = load("PET_07.mat");
PET07 = PET07.PET;
disp("07")

PET08 = load("PET_08.mat");
PET08 = PET08.PET;
disp("08")

PET09 = load("PET_09.mat");
PET09 = PET09.PET;
disp("09")

PET10 = load("PET_10.mat");
PET10 = PET10.PET;
disp("10")

PET11 = load("PET_11.mat");
PET11 = PET11.PET;
disp("11")

PET12 = load("PET_12.mat");
PET12 = PET12.PET;
disp("12")

PET_tot = (PET01 + PET02 + PET03 + PET04 + PET05 + PET06 + ...
     PET07 + PET08 + PET09 + PET10 + PET11 + PET12) ./ 12;
disp("PET_tot")

clear PET01 PET02 PET03 PET04 PET05 PET06 PET07 PET08 PET09 PET10 PET11 PET12

%%

disp("Calculation of the Wetness Index")

WI_avg = prec_tot ./ PET_tot;

%%

disp("Saving the results...")

save("WI_avg.mat", "WI_avg", "-v7.3")
geotiffwrite("WI_avg.tif", WI_avg, ref);

disp("COMPLETE.")

%% Mostra l'immagine con imagesc

[WI_avg, ref] = readgeoraster("WI_avg.tif");

%%
WI_avg = WI_avg(1:18000, :);

%% PROBABILITY

thresholds = [2, 2.5, 3];

prob_non_superamento = arrayfun(@(t) sum(WI_avg(~isnan(WI_avg)) <= t) / numel(WI_avg(~isnan(WI_avg))), thresholds);

disp('Non-exceedance probability for each threshold is:')
disp(table(thresholds', prob_non_superamento', 'VariableNames', {'Threshold', 'Probability'}))

%% CDF
figure;
cdf = cdfplot(WI_avg(~isnan(WI_avg))); 
cdf.LineWidth = 2;
hold on;
y1 = sum(WI_avg(~isnan(WI_avg)) <= thresholds(1))/numel(WI_avg(~isnan(WI_avg)));
y2 = sum(WI_avg(~isnan(WI_avg)) <= thresholds(2))/numel(WI_avg(~isnan(WI_avg)));
y3 = sum(WI_avg(~isnan(WI_avg)) <= thresholds(3))/numel(WI_avg(~isnan(WI_avg)));
hold on;
plot(thresholds(1), y1, '.', 'MarkerSize',30, 'Color', [0, 0, 0]);
hold on;
plot(thresholds(2), y2, '.', 'MarkerSize',30, 'Color', [0.4, 0.4, 0.4]);
hold on;
plot(thresholds(3), y3, '.', 'MarkerSize',30, 'Color', [0.7, 0.7, 0.7]);
leg0 = 'CDF';
leg1 = sprintf('P(X ≤ %.1f) = %.3f', thresholds(1), y1);
leg2 = sprintf('P(X ≤ %.1f) = %.3f', thresholds(2), y2);
leg3 = sprintf('P(X ≤ %.1f) = %.3f', thresholds(3), y3);
legend(leg0, leg1, leg2, leg3, 'Location', 'southeast');
xlabel('Wetness index (P/PET)');
ylabel('Cumulative probability');

grid on;
hold off;


%%

%WI_avg = load("WI_avg.mat");
%WI_avg = WI_avg.WI_avg;

figure();

X = linspace(ref.LatitudeLimits(1), ref.LatitudeLimits(2), ref.RasterSize(1));
Y = linspace(ref.LongitudeLimits(1), ref.LongitudeLimits(2), ref.RasterSize(2));

h = imagesc(X, Y, WI_avg);
colormap;

% Imposta la threshold
threshold = 2; 

% Definiamo i colori in formato RGB normalizzato [0,1]
blue_start = [166, 203, 216] / 255;  
blue_end   = [27, 68, 148] / 255;  
red_start  = [200, 50, 67] / 255;  
red_end    = [239, 206, 85] / 255;   

% Numero totale di colori nella colormap
nColors = 256;  

% Threshold nella colormap
minVal = min(WI_avg(:));  
maxVal = max(WI_avg(:)); 
thresholdIdx = round((threshold - minVal) / (maxVal - minVal) * nColors);  

cmap = zeros(nColors, 3);  

% Gradiente blu (0 - threshold)
for i = 1:thresholdIdx
    alpha = (i - 1) / (thresholdIdx - 1);  % Normalizzazione da 0 a 1
    cmap(i, :) = (1 - alpha) * red_start + alpha * red_end;
end

% Gradiente rosso (threshold - 18)
for i = thresholdIdx+1:nColors
    alpha = (i - thresholdIdx) / (nColors - thresholdIdx);  % Normalizzazione da 0 a 1
    cmap(i, :) = (1 - alpha) * blue_start + alpha * blue_end;
end

% Applichiamo la colormap personalizzata
colormap(cmap);
caxis([minVal, maxVal]);  % Imposta i limiti di colore sulla scala reale


% Rendi trasparenti i NaN
set(h, 'AlphaData', ~isnan(WI_avg));  % Opacità = 0 per NaN, 1 per il resto
set(gca, 'Color', 'w');  % Sfondo bianco (opzionale)
yticks = get(gca, 'YTick');  % Legge i valori correnti dell'asse Y
set(gca, 'YTickLabel', flip(yticks));

xlabel("Easting", "FontWeight","bold")
ylabel("Northing", "FontWeight","bold")

ylim([-180, 120])

% Aggiungi una barra colore
cb = colorbar;
cb.Ticks = 0:threshold:18;

% Aggiunta dell'etichetta
ylabel(cb, 'Wetness Index (P/PET)', 'FontSize', 12, 'FontWeight', 'bold', 'Rotation',90);



toc